#!/usr/bin/env bash

# Parameters
env_name="InvertedPendulum-v2"
seeds=(0 1 2 3 4)
model_dir="models"
count=0

# Log file for job submissions
log_file="job_submission_log.txt"
> $log_file  # Clear the log file at the start

for seed in "${seeds[@]}"; do
    model_path="${model_dir}/SAC_${env_name}_${seed}_True_final"

    # Check if the model already exists
    if ! [ -f "$model_path" ]; then
      sbatch --job-name="train_${env_name}_${seed}" train_sac.sh $seed $env_name
      echo "Submitted job for seed=$seed, steps=$steps" | tee -a $log_file
      count=$((count + 1))
    else
      echo "Model already exists: $model_path. Skipping job submission for seed=$seed" | tee -a $log_file
    fi
done

echo "Launched $count jobs."
